### -*- Mode: perl -*-

use ReDIF::Parser;

###
###  This test must check if parser option
###  'remove_newline_from_values' works
###  

use Test;
use strict;


BEGIN { plan tests => 2 }


ReDIF::Parser::open_file( 't/1995.rdf' );

my $t = ReDIF::Parser::get_next_template();

use Data::Dumper;
$Data::Dumper::Varname = 'template';
print Dumper( $t );

ok( $t->{abstract}[0] =~ /\n/ );


ReDIF::Parser::set_parser_options( remove_newline_from_values => 1 );


ReDIF::Parser::open_file( 't/1995.rdf' );

$t = ReDIF::Parser::get_next_template();

print Dumper( $t );

ok( $t->{abstract}[0] !~ /\n/ );




