# -*- Mode: perl -*-
# test script to test comments in ReDIF data


use Test;

BEGIN {  plan tests => 4; }

use ReDIF::Parser qw( &redif_open_file &redif_get_next_template );

ok 1;

my $r;
my $t;

$r = redif_open_file( 't/comments.rdf' );

ok( $r );

$t = redif_get_next_template();

ok( $t );

print "paper's title: " , $t->{'title'}[0], "\n";

ok( $t->{'title'}[0] eq "some\ntitle" );


__END__

my $authors = $t->{author};

test( scalar( @$authors ) == 2 );

my $h = $t->{handle};

test( (scalar( @$h ) == 1 ) , $h->[0] );

test( $h->[0] );

my $tt = $t->{'template-type'};

test( (scalar( @$tt ) == 1 ) , $tt->[0] );



