<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">
  
  <xsl:import href='page.xsl'/>
  <xsl:import href='page-universal.xsl'/>

  <xsl:import href='misc/login.xsl'/>
  
<!--
  <xsl:template match='text()'/>
-->

  <xsl:variable name='current-screen-id'>homepage</xsl:variable>


  <xsl:variable name='full-page-title'>
    <xsl:value-of select='$site-name-long'/>
<!--
    <xsl:call-template name='link-filter'>
      <xsl:with-param name='content'>
        <phrase ref='homepage-title'><xsl:value-of
        select='$site-name-long'/></phrase>
      </xsl:with-param>
    </xsl:call-template>
-->
  </xsl:variable>
  
  
  <xsl:template match="/data">
<!--
    <xsl:call-template name='appropriate-page-soft'>
-->
    <xsl:call-template name='page'>
      <xsl:with-param name='into-the-top'>
        <xsl:choose>
          <xsl:when test='$session-type = "new-user"'>
            <xsl:call-template name='new-user-logged-notice'/>
          </xsl:when>
          <xsl:when test='$session-type = "user"'>
            <xsl:call-template name='user-logged-notice'/>
          </xsl:when>
          <xsl:when test='not( $session-type )
                    and //auto-login-possible'>
                <xsl:for-each select='//auto-login-possible'>
                  <p class='logged-notice'>
                    <a class='int' href='{$base-url}/welcome' 
                       title='Enter into your account!'
                       >Welcome, <span title='{login/text()}' class='name'
                    ><xsl:value-of select='name' /></span >!</a>
                  </p>
            </xsl:for-each>
          </xsl:when>
        </xsl:choose>
      </xsl:with-param>

      <xsl:with-param name='content' xml:space='preserve'>

<!--
        <phrase ref='announcements'/>
-->
        <phrase ref='service-intro'/>
        
        <phrase ref='news'/>

        <h2>New registration</h2>
        
        <ul> 

         <xsl:if test='$user-name and ($session-type = "new-user")'>
           
           <li><a ref='new-user/additional' title='to step 2' tabindex='1' 
           >Continue registration of
           <span class='name' ><xsl:value-of select='$user-name' /></span>
           (<xsl:value-of select='$user-login' />)</a></li>
         </xsl:if>

         <li><a ref='new-user!' tabindex='1' 
         title='Takes 6 steps and a working email address'
         >Register now</a></li>

        </ul>

        <h2>Login</h2>

         <xsl:call-template name='show-status'/>

         <xsl:variable name='auto-login' select='//auto-login-possible'/>
         <xsl:if test='$auto-login'>
           
           <ul>
             <li><a ref='welcome' tabindex='1'>As <span class='name' ><xsl:value-of
             select='$auto-login/name' /></span> (<xsl:value-of
             select='$auto-login/login' />)</a></li>
           </ul>

           <p>...Or enter as another user:</p>
         </xsl:if>


         <xsl:if test='$user-name and ($session-type = "user")'>
           
           <ul>
             <li><a ref='welcome' title='to main menu' >Already logged-in as
             <span class='name' ><xsl:value-of select='$user-name' /></span>
             (<xsl:value-of select='$user-login' />)</a></li>
           </ul>
         </xsl:if>



         <xsl:call-template name='login-form' xml:space='default'>
           <xsl:with-param name='no-auto-login-focus' select='"1"'/>
         </xsl:call-template>

    </xsl:with-param>
  </xsl:call-template> <!-- /page -->
</xsl:template>


</xsl:stylesheet>

